<?php

namespace App\Http\Controllers;

use Alert;
use App\Models\ShareData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Str;

class ShareDataController extends Controller
{
    public function show()
    {

        $share_data = ShareData::all();

        if(session()->has('success')) {
            Alert::success('Success', session()->get('success'));
        }

        if(session()->has('error')) {
            Alert::error('error', session()->get('error'));
        }

        return view('admin.share_data.form', compact('share_data'));
    }

    public function update(Request $request)
    {

        $status = 0;

        try {
            
            $share_data = ShareData::where('type', $request->type)->first();
            if($share_data) {

                $inputs = $request->all();
                if($request->img) {
                    $img = $this->uploadImage($request, 'img', 'share_data');
                    $inputs['image_path'] = $img;
                }

                // Loop through the input fields and update the JSON data
                $json_data = [];
                foreach ($inputs as $key => $value) {
                    if ($key !== '_token' && $key !== 'submit' && $key !== 'type' && $key !== 'img') {
                        $json_data[$key] = $value;
                    }
                }

                $share_data->fill([ 'data'=> json_encode($json_data, JSON_UNESCAPED_UNICODE) ]);

                if($share_data->save()) {
                    $status = 1;
                }
            }

        } catch (\Throwable $th) {
            //throw $th;
        }


        if($status == 1) {
            Session()->flash('success', 'Record Updated Successfully !');
        } else {
            Session()->flash('error', 'Soemthing went wrong !');
        }

        return redirect()->back();
    }

    public function uploadImage(Request $request, $file_name, $folder_name) {

        $img = $request->file($file_name);

        $imgRules = [
            $file_name => 'required|mimes:jpeg,jpg,png,webp|max:1024',
        ];
        $customImageMessages = [
            'required' => 'Image field is required',
            'mimes' => 'Image type not allowed',
            'max' => 'Image size shouldn\'t be grater than 1MB',
        ];
        $this->validate($request, $imgRules, $customImageMessages);

        $imgName = uniqid().'_'.Str::random(6).'.'.$img->extension();

        $img->move(public_path('uploads/'.$folder_name), $imgName);

        $image_path = 'https://admin.bgneh.com/uploads/'.$folder_name.'/'.$imgName;

        return $image_path;
        
    }

    public function share_link_page($type) {

        $link = 'https://www.bgneh.com';
        $data = [];

        try {
            $share_data = ShareData::where('type', $type)->first();
            if($share_data) {
                $data = json_decode($share_data->data);

                if (is_object($data)) {
                    if (property_exists($data, 'link')) {
                        $link = $data->link;
                    }
                }
            }
        } catch (\Throwable $th) {
            //throw $th;
        }

        return view('share_data.share_data', compact('type', 'link', 'data'));
    }

    public function share_link_save(Request $request) {

        try {
            if($request->type && $request->uaIP && $request->uaOS) {
            
                if($request->uaOS == 'iOS') {
                   $os = 1;
                } elseif($request->uaOS == 'Android') {
                   $os = 2;
                } else {
                    $os = 0;
                }
                
                DB::table('share_data_stats')->insert([
                    "type" => $request->type,
                    "os" => $os,
                    "ip_address" => $request->uaIP,
                ]);
                
            }
        } catch (\Exception $e) {
            \Log::error($e->getMessage());
        }

        return response()->json(['status'=>1]);
        
    }
}
