<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>BGNEH</title>

    @if (isset($data) && is_object($data))
    @foreach ($data as $key => $value)
    <meta property='og:{{$key}}' content='{{$value}}'>
    @endforeach  
    @endif

    <meta property='og:type' content='product'>
    <meta property='og:url' content='https://bgneh.com'>
    <meta property='og:site_name' content='BGNEH'>
    
    <meta property='og:email' content='admin@bgneh.com'>
    <meta property='og:phone_number' content='+201120000338'>
    
    <meta property='og:street-address' content='1st Zaitoun Cairo'>
    <meta property='og:region' content='CA'>
    <meta property='og:country-name' content='EG'>

    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" type="image/x-icon" href="{{asset('assets/images/favicon.png')}}">
    


    <style>
        .spinner-container{
            width: 100%;
            height: 100%;
            position: fixed;
            left: 0;
            top: 0;
            background-color: #fff;
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .spinner-container.hidden {
            display: none;
        }
        .spinner{
            width: 80px;
            height: 80px;
            border: 7px solid #e40a14;
            border-top-color: transparent;
            border-radius: 50%;
            animation: spinner 0.7s linear infinite;
            margin-left: 10px;
        }
        @keyframes spinner{
            from{}
            to{
            transform: rotate(360deg);
            }
        }

        @media(max-width: 767px) {
            .spinner {
                width: 35px;
                height: 35px;
            }
            .spinner-container div{
                font-size: 18px !important
            }
        }
    </style>
</head>
<body>

    <div class="spinner-container">
        <div style="font-size: 20px; text-align:center">You are being redirected now</div>
        <div class="spinner"></div>
    </div>


    <!-- jquery latest version -->
    <script src="{{asset('assets/js/vendor/jquery-2.2.4.min.js')}}"></script>
    {{-- Detect Mobile  --}}
    <script src="{{asset('assets/js/plugins/detect-mobile.min.js')}}"></script>

    <script>
        $(document).ready(function() {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            var ua, uaOS, uaIP, type;
            ua = detect.parse(navigator.userAgent);
            uaOS = ua.os.family;
            type = "{{$type}}";

            fetch('https://api.ipify.org/?format=json')
                .then(results => results.json())
                .then(data => uaIP = data.ip )
                .then(() => {
                    var data = {
                        "uaIP" : uaIP,
                        "uaOS" : uaOS,
                        "type" : type,
                    };
                sendAjaxRequest(data);
            });

            function sendAjaxRequest(data) {
                
                $.ajax({
                    type: "POST",
                    url: "{{route('share_data_save')}}",
                    data:data,
                    success: function(response)
                    {
                        // location.href = response.href;
                        console.log(response);
                    }
                });
                
            }

        });
    </script>
        
</body>
</html>