
<?php $__env->startSection('title'); ?>
    <?php echo e(isset($copoun) ? $copoun->copoun_code : 'Create Coupon'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Textual inputs start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">
                    <?php echo e(isset($copoun) ? 'Update copoun' : 'Create copoun'); ?>

                </h4>
                <form method="POST" action="<?php echo e(isset($copoun) ? route('copouns.update',['copoun'=>$copoun->id]):route('copouns.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <label for="copoun_code" class="col-form-label">Coupon Code</label>
                        <input class="form-control" name="copoun_code" type="text" id="copoun_code" value="<?php echo e(isset($copoun) ? $copoun->copoun_code : old('copoun_code')); ?>" required placeholder="Enter copoun_code">
                        <?php if($errors->has('copoun_code')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('copoun_code')); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="product_id" class="col-form-label">Product Id</label>
                        <input class="form-control" name="product_id" type="number" id="product_id" value="<?php echo e(isset($copoun) ? $copoun->product_id : old('product_id')); ?>" placeholder="Enter product_id">
                        <?php if($errors->has('product_id')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('product_id')); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="start_date" class="col-form-label">Start Date</label>
                        <input class="form-control" name="start_date" type="date" id="start_date" required value="<?php echo e(isset($copoun) ? $copoun->start_date : old('start_date')); ?>" placeholder="Enter start_date">
                        <?php if($errors->has('start_date')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('start_date')); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="end_date" class="col-form-label">End Date</label>
                        <input class="form-control" name="end_date" type="date" id="end_date" required value="<?php echo e(isset($copoun) ? $copoun->end_date : old('end_date')); ?>" placeholder="Enter end_date">
                        <?php if($errors->has('end_date')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('end_date')); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="client_use" class="col-form-label">client use</label>
                        <input class="form-control" name="client_use" type="number" id="client_use" required value="<?php echo e(isset($copoun) ? $copoun->client_use : old('client_use')); ?>" placeholder="Enter client_use">
                        <?php if($errors->has('client_use')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('client_use')); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <label for="total_usage" class="col-form-label">total usage</label>
                        <input class="form-control" name="total_usage" type="number" id="total_usage" required value="<?php echo e(isset($copoun) ? $copoun->total_usage : old('total_usage')); ?>" placeholder="Enter total_usage">
                        <?php if($errors->has('total_usage')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('total_usage')); ?></p>
                        <?php endif; ?>
                    </div>

                    
                    
                    <div class="form-group">
                        <label for="active" class="col-form-label mr-2">Active</label>
                        <?php if(isset($copoun)): ?>
                        <input name="active" type="checkbox" id="active" value="1" <?php echo e($copoun->active == 1 ? 'checked' : ''); ?>>
                        <?php else: ?>
                        <input name="active" type="checkbox" id="active" value="1">
                        <?php endif; ?>
                    </div>

                    <button type="submit" name="submit" class="btn btn-primary mt-4 pr-4 pl-4">
                        <?php echo e(isset($copoun) ? 'Update' : 'Create'); ?>

                    </button>

                </form>
                
            </div>
        </div>
    </div>
    <!-- Textual inputs end -->

    <?php if(isset($copoun->applied_copoun)): ?>
    <!-- data table start -->
    <div class="col-12 mt-4">
        <div class="card">
            <div class="card-body">
                <div class="clearfix">
                    <h4 class="header-title float-left"><i class="fa fa-users custom-icon"></i>Applied Coupons</h4>
                </div>
                <div class="data-tables mt-4">
                    <table id="dataTable" class="text-center">
                        <thead class="bg-light text-capitalize">
                            <tr>
                                <th class="all">Coupon ID</th>
                                <th class="all">Customer Name</th>
                                <th class="all">Customer ID</th>
                                <th class="all">Added date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $copoun->applied_copoun; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $applied_copoun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <input type="hidden" class="deleted_id" value="<?php echo e($applied_copoun->id); ?>">
                                    <td><?php echo e($applied_copoun->copoun_id); ?></td>
                                    <td><?php echo e(isset($applied_copoun->customer) ? $applied_copoun->customer->firstname . ' ' .$applied_copoun->customer->lastname : ''); ?></td>
                                    <td><?php echo e($applied_copoun->id_customer); ?></td>
                                    <td><?php echo e(date('m/d/Y', strtotime($applied_copoun->date_added))); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- data table end -->

    <?php endif; ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/copouns/form.blade.php ENDPATH**/ ?>