

<?php $__env->startSection('title', 'Transaction verifier'); ?>

<?php $__env->startSection('content'); ?>
<div class="loader-container hidden">
	<div class="loader-spinner"></div>
</div>

    <div class="col-12 mb-3" style="max-width: 97%; margin: 0 auto">
        <form action="<?php echo e(route('transaction_verifier')); ?>" method="get">

            <div class="row bg-white py-4">
                <div class="col-3">
                    <div class="form-group">
                        <input type="number" class="form-control" name="phoneNumber" required value="<?php echo e(isset($customer->phoneNumber) ? $customer->phoneNumber : ''); ?>" placeholder="Phone Number">
                    </div>
                </div>
              
                <div class="col-3">
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary" style="width: 100%; font-size: 14px">Filter</button>
                    </div>
                </div>
            </div>

        </form>
    </div>


        <div class="col-12">

            <!-- Recharge transactions start -->
            <?php if($recharge_transactions): ?>
            <div class="card mt-4">
                <div class="card-body">
                    <h4 class="header-title">Recharge transactions</h4>
                    <div class="data-tables mt-4">
                        <table id="dataTable" class="text-center">
                            <thead class="bg-light text-capitalize">
                                <tr>
                                    <th class="all">ID</th>
                                    <th class="all">Recharge Amount</th>
                                    <th class="all">Payment Method</th>
                                    <th class="all">State</th>
                                    <th class="all">Action</th>
                                    <th class="all">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $recharge_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recharge_transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php 
                                    if ($recharge_transaction->state == null) {
                                        $recharge_transaction->state = 'Pending';
                                    }
                                    elseif($recharge_transaction->state == 5) {
                                        $recharge_transaction->state = 'Accepted';
                                    }
                                    elseif($recharge_transaction->state == 10) {
                                        $recharge_transaction->state = 'Rejected';
                                    }
                                    ?>
                                    
                                    <tr>
                                        <td><a href="customers/<?php echo e($recharge_transaction->user_id); ?>"><?php echo e($recharge_transaction->id); ?></a></td>
                                        <td><?php echo e($recharge_transaction->recharge_amount); ?></td>
                                        <td><?php echo e($recharge_transaction->payment_method); ?></td>
                                        <td><?php echo e($recharge_transaction->state); ?></td>
                                        <td>
                                            <?php if($recharge_transaction->state == 'Pending'): ?>
                                            <a href="#" class="text-purple accept-transaction" data-transaction-id="<?php echo e($recharge_transaction->id); ?>">
                                                <i class="fa fa-check-square-o" style="font-size: 15px !important; margin-right: 5px" aria-hidden="true"></i>Accept
                                            </a>
                                            <?php else: ?>
                                            ~~
                                            <?php endif; ?>
                                            
                                        </td>
                                        <?php $date_added = explode(" ",$recharge_transaction->date_added); ?>
                                        <td><?php echo e(isset($date_added[0]) ? $date_added[0] : ''); ?> &nbsp; - &nbsp; <?php echo e(isset($date_added[1]) ? $date_added[1] : ''); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
            <?php endif; ?>
            <!-- Recharge transactions end -->

             <!-- Customer wallet start -->
            <?php if(isset($customer->wallet)): ?>

            <div class="card mt-4">
                <div class="card-body">
                    <h4 class="header-title">Customer Wallet</h4>
                    <div class="data-tables mt-4">

                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col" class="text-capitalize">fullname</th>
                                    <th scope="col"><?php echo e($customer->firstname); ?> <?php echo e($customer->lastname); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class="text-capitalize">Wallet amount</td>
                                    <td><?php echo e($customer->wallet->amount); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-capitalize">Wallet date added</td>
                                    <td><?php echo e(date('d-m-Y', strtotime($customer->wallet->date_added))); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-capitalize">Wallet date updated</td>
                                    <td><?php echo e(date('d-m-Y', strtotime($customer->wallet->date_updated))); ?></td>
                                </tr>
                            </tbody>
                        </table>

                    </div>

                </div>
            </div>

            <?php endif; ?>
            <!-- Customer wallet end -->


            
            <?php if(count($productsSubscription) > 0): ?>
            <div class="card mt-4">
                <div class="card-body">
                    <h4 class="header-title">
                        Customer Subscriptions products
                    </h4>
                    <div class="data-tables">
                        <table id="dataTable2">
                            <thead class="bg-purple text-white">
                            <tr>
                                <th class="all">ProductID</th>
                                <th class="all">Product</th>
                                <th class="all" >Subscription Amount</th>
                                <th class="all" >Date Of Subscription</th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $productsSubscription; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productSubscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(isset($productSubscription->product)): ?>
                                <?php $productImages = explode(', ', $productSubscription->product->images); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(url('admin/products/'.$productSubscription->product->id)); ?>" class="text-purple">
                                            <?php echo e($productSubscription->product->id); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <img src="<?php echo e(asset('/uploads/products/'.$productImages[0])); ?>"
                                            class="avatar avatar-sm me-3" alt="xd">
                                        <?php echo e($productSubscription->product->name); ?>

                                    </td>
                                    <td><?php echo e($productSubscription->subscription_amount); ?></td>
                                    <td><?php echo e(date('d M Y', strtotime($productSubscription->date_added))); ?></td>
                                </tr>
                                <?php $i++; ?>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            
            <?php if(count($freeProductsSubscription) > 0): ?>
            <div class="card mt-4">
                <div class="card-body">
                    <h4 class="header-title">
                        Customer Subscriptions Freegift Products
                    </h4>
                    <div class="data-tables">
                        <table id="dataTable3">
                            <thead class="bg-purple text-white">
                            <tr>
                                <th class="all">ProductID</th>
                                <th class="all">Product</th>
                                <th class="all">Subscription Amount</th>
                                <th class="all">Date Of Subscription</th>
                            </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $freeProductsSubscription; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $freeProductSubscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(isset($freeProductSubscription->product)): ?>
                                <?php $productImages = explode(', ', $freeProductSubscription->product->images); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(url('admin/freegift_products/'.$freeProductSubscription->product->id)); ?>" class="text-purple">
                                            <?php echo e($freeProductSubscription->product->id); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <img src="<?php echo e(asset('/uploads/products/'.$productImages[0])); ?>"
                                            class="avatar avatar-sm me-3" alt="xd">
                                        <?php echo e($freeProductSubscription->product->name); ?>

                                    </td>
                                    <td><?php echo e($freeProductSubscription->subscription_amount); ?></td>
                                    <td><?php echo e(date('d M Y', strtotime($freeProductSubscription->date_added))); ?></td>
                                </tr>
                                <?php $i++; ?>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php endif; ?>


        </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
	<script type="text/javascript">

		$(document).ready(function() {
			$.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
			});

            // Accept transaction function
			$('#dataTable').on('click', '.accept-transaction', function(e) {
				e.preventDefault();
				var transaction_id = $(this).data("transaction-id");

				swal({
                    title: "Are you sure?",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
				})
				.then((confirm) => {
                    if (confirm) {

                        $('.loader-container').removeClass('hidden');

                        $.ajax({
                            type: "get",
                            url: "<?php echo e(route('accept_transaction')); ?>",
                            data: {transaction_id: transaction_id},
                            success: function(response)
                            {
                                $('.loader-container').addClass('hidden');
                                swalWithReload(response.message, response.status, true);
                                
                            }, error: function() {
                                $('.loader-container').addClass('hidden');
                                swalWithReload('Something went wrong.', 0, true);

                            }
                        });

                    }

				});
			});

		});
        
        function swalWithReload(message, status, reload) {
            var icon;
            status == 1 ? icon = 'success' : icon = 'error';

            if(reload) {
                swal(message, {
                        icon: icon,
                    })
                    .then((result) => {
                        location.reload();
                });
            }
        }

    
	</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/transaction_verifier/index.blade.php ENDPATH**/ ?>