

<?php $__env->startSection('title'); ?>
    <?php echo e(isset($product) ? $product->name : 'Create product'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Textual inputs start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">
                    <?php echo e(isset($product) ? 'Update product' : 'Create product'); ?>

                </h4>
                <form method="POST" action="<?php echo e(isset($product) ? route('products.update',['product'=>$product->id]):route('products.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label for="category_id" class="col-form-label">Categroy</label>
                        <select name="category_id" id="category_id" class="form-control" required>
                            <option value="">Choose Category</option>
                            <?php $__currentLoopData = App\Models\Category::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e((isset($product) && $category->id === $product->category_id) ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('category_id')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('category_id')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="name" class="col-form-label">name</label>
                        <input class="form-control" name="name" type="text" id="name" value="<?php echo e(isset($product) ? $product->name : old('name')); ?>" placeholder="Enter name">
                        <?php if($errors->has('name')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="name_ar" class="col-form-label">Arabic name</label>
                        <input class="form-control" name="name_ar" type="text" id="name_ar" value="<?php echo e(isset($product) ? $product->name_ar : old('name_ar')); ?>" placeholder="Enter Arabic name">
                        <?php if($errors->has('name_ar')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('name_ar')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="price" class="col-form-label">price</label>
                        <input class="form-control" name="price" type="text" id="price" value="<?php echo e(isset($product) ? $product->price : old('price')); ?>" placeholder="Enter price">
                        <?php if($errors->has('price')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('price')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="description" class="col-form-label">Description</label>
                        <textarea class="description" name="description"><?php echo e(isset($product) ? $product->description : old('description')); ?></textarea>
                        <?php if($errors->has('description')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="description_ar" class="col-form-label">Arabic Description</label>
                        <textarea class="description" name="description_ar"><?php echo e(isset($product) ? $product->description_ar : old('description_ar')); ?></textarea>
                        <?php if($errors->has('description_ar')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('description_ar')); ?></p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="customer_ratio" class="col-form-label">Customer Ratio</label>
                        <input class="form-control" name="customer_ratio" type="text" id="customer_ratio" value="<?php echo e(isset($product) ? $product->customer_ratio : old('customer_ratio')); ?>" placeholder="Enter Customer Ratio">
                        <?php if($errors->has('customer_ratio')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('customer_ratio')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="maximum_payment" class="col-form-label">Maximum Payment</label>
                        <input class="form-control" name="maximum_payment" type="text" id="maximum_payment" value="<?php echo e(isset($product) ? $product->maximum_payment : old('maximum_payment')); ?>" placeholder="Enter Maximum Payment">
                        <?php if($errors->has('maximum_payment')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('maximum_payment')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">

                        <?php
                            isset($product) ? $is_active = $product->is_active : $is_active = 0;
                        ?>
                        <label for="is_active" class="col-form-label mr-1">Active</label>
                        <input type="radio" name="is_active" value="1" <?php echo e($is_active == 1 ? 'checked' : ''); ?>>
                        <label for="is_active" class="col-form-label ml-3 mr-1">Not Active</label>
                        <input type="radio" name="is_active" value="0" <?php echo e($is_active == 0 ? 'checked' : ''); ?>>
                        <label for="is_active" class="col-form-label ml-3 mr-1">Coming Soon</label>
                        <input type="radio" name="is_active" value="3" <?php echo e($is_active == 3 ? 'checked' : ''); ?>>
                    </div>
                    
                    <div class="form-group">

                        <?php
                            isset($product) ? $pin_to_top = $product->pin_to_top : $pin_to_top = 0;
                        ?>
                        <input type="checkbox" name="pin_to_top" value="1" <?php echo e($pin_to_top == 1 ? 'checked' : ''); ?>>
                        <label for="pin_to_top" class="col-form-label ml-1">Pin To Top</label>
                    </div>
                    
                    <div class="form-group">
                        <label for="images" class="col-form-label">Gallery</label>
                        <input class="form-control" multiple name="images[]" type="file" accept="image/*" id="images" <?php echo e(isset($product) ? '' : 'required'); ?>>
                        <?php if($errors->has('images.*')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('images.*')); ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Gallery -->
                    <?php if(isset($product->images)): ?>
                    
                    <div class="row">
                        <?php $images = explode(', ', $product->images); ?>
                        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($image == null): ?>
                            <?php continue; ?>
                        <?php endif; ?>
                        <div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
                            <img
                                src="<?php echo e(asset('/uploads/products/'.$image)); ?>"
                                class="w-100 shadow-1-strong rounded mb-4 img-fluid"
                                alt="<?php echo e($product->name); ?>"
                            />
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <?php endif; ?>

                    <?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 3): ?>
                    
                    <button type="submit" name="submit" class="btn btn-primary mt-4 pr-4 pl-4">
                        <?php echo e(isset($product) ? 'Update' : 'Create'); ?>

                    </button>

                    <?php endif; ?>
                </form>

            </div>
        </div>

        <?php if(isset($product)): ?>
        
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Fake Real
                </h4>

                <?php if($fake_real_sub): ?>

                <table class="table">
                    <thead>
                      <tr>
                        <th >ID</th>
                        <th >Subscription amount</th>
                        <th >Date added</th>
                      </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><?php echo e($fake_real_sub->id); ?></td>
                            <td><?php echo e($fake_real_sub->subscription_amount); ?></td>
                            <td><?php echo e(date('Y-M-d', strtotime($fake_real_sub->date_added))); ?></td>
                        </tr>
                    </tbody>
                </table>

                <?php else: ?>

                <form method="POST" action="<?php echo e(route('products-addfakereal')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                   
                    <div class="form-group">
                        <label class="col-form-label">Amount</label>
                        <input name="product_id" type="hidden" value="<?php echo e($product->id); ?>">
                        <input class="form-control" name="amount" type="number" min="1" placeholder="Enter amount" required>
                        <?php if($errors->has('amount')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('amount')); ?></p>
                        <?php endif; ?>
                    </div>

                    <?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 3): ?>
                    
                    <button type="submit" name="submit" class="btn btn-primary mt-4 pr-4 pl-4">
                       Add Fake Real
                    </button>

                    <?php endif; ?>
                </form>
                <?php endif; ?>
                

                

            </div>
        </div>
        
        <?php endif; ?>

        
        <?php if(count($customersSubscriptions) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Customer Subscriptions
                </h4>
                <div class="data-tables">
                    <table id="dataTable">
                        <thead class="bg-purple text-white">
                        <tr>
                            <th class="all" >CustomerID</th>
                            <th class="all" >Customer</th>
                            <th class="all" >Subscription Amount</th>
                            <th class="all" >Date Of Subscription</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $customersSubscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customerSubscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(isset($customerSubscription->customer)): ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(url('admin/customers/'.$customerSubscription->user_id)); ?>" class="text-purple">
                                        <?php echo e($customerSubscription->user_id); ?>

                                    </a>
                                </td>
                                <td>
                                    <?php if($customerSubscription->customer->avatar): ?>
                                    <img src="<?php echo e(asset('/uploads/products/'.$customerSubscription->customer->avatar->avatar_url)); ?>"
                                        class="avatar avatar-sm me-3" alt="xd">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('backend/assets')); ?>/images/team-4.jpg"
                                            class="avatar avatar-sm me-3" alt="xd">
                                    <?php endif; ?>
                                    <?php echo e($customerSubscription->customer->firstname); ?> <?php echo e($customerSubscription->customer->lastname); ?>

                                </td>
                                <td><?php echo e($customerSubscription->subscription_amount); ?></td>
                                <td><?php echo e(date('d M Y', strtotime($customerSubscription->date_added))); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
            </div>
        </div>
        <?php endif; ?>


        
        <?php if(isset($participations_history_filename) && count($participations_history_filename) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title text-capitalize">
                    participations history logs
                </h4>
                <table class="table">
                    <thead class="bg-purple text-white">
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">File</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $participations_history_filename; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($i); ?></td>
                            <td>
                                <?php echo e($file); ?>.txt
                                <a href="<?php echo e(Url('admin/filedownload/'.$file)); ?>"><i class="fa fa-download text-purple ml-3"></i></a>
                            </td>
                        </tr>
                        <?php $i++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <!-- Textual inputs end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    tinymce.init({
      selector: '.description'
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/products/form.blade.php ENDPATH**/ ?>