

<?php $__env->startSection('title'); ?>
    <?php echo e(isset($product) ? $product->name : 'Create free product'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="loader-container hidden">
	<div class="loader-spinner"></div>
</div>

    <!-- Textual inputs start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title">
                    <?php echo e(isset($product) ? 'Update free product' : 'Create free product'); ?>

                </h4>
                <form method="POST" action="<?php echo e(isset($product) ? route('freegift_products.update',['freegift_product'=>$product->id]):route('freegift_products.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label for="category_id" class="col-form-label">Categroy</label>
                        <select name="category_id" id="category_id" class="form-control" required>
                            <option value="">Choose Category</option>
                            <?php $__currentLoopData = App\Models\Category::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e((isset($product) && $category->id === $product->category_id) ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($errors->has('category_id')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('category_id')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="name" class="col-form-label">name</label>
                        <input class="form-control" name="name" type="text" id="name" value="<?php echo e(isset($product) ? $product->name : old('name')); ?>" placeholder="Enter name">
                        <?php if($errors->has('name')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="name_ar" class="col-form-label">Arabic name</label>
                        <input class="form-control" name="name_ar" type="text" id="name_ar" value="<?php echo e(isset($product) ? $product->name_ar : old('name_ar')); ?>" placeholder="Enter Arabic name">
                        <?php if($errors->has('name_ar')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('name_ar')); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="description" class="col-form-label">Description</label>
                        <textarea class="description" name="description"><?php echo e(isset($product) ? $product->description : old('description')); ?></textarea>
                        <?php if($errors->has('description')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="description_ar" class="col-form-label">Arabic Description</label>
                        <textarea class="description" name="description_ar"><?php echo e(isset($product) ? $product->description_ar : old('description_ar')); ?></textarea>
                        <?php if($errors->has('description_ar')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('description_ar')); ?></p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="form-group">

                        <?php
                            isset($product) ? $is_active = $product->is_active : $is_active = 0;
                        ?>
                        <label for="is_active" class="col-form-label mr-1">Active</label>
                        <input type="radio" name="is_active" value="1" <?php echo e($is_active == 1 ? 'checked' : ''); ?>>
                        <label for="is_active" class="col-form-label ml-3 mr-1">Not Active</label>
                        <input type="radio" name="is_active" value="0" <?php echo e($is_active == 0 ? 'checked' : ''); ?>>
                        <label for="is_active" class="col-form-label ml-3 mr-1">Coming Soon</label>
                        <input type="radio" name="is_active" value="3" <?php echo e($is_active == 3 ? 'checked' : ''); ?>>
                    </div>

                    <div class="form-group">
                        <label for="end_date" class="col-form-label">End Date</label>
                        <input class="form-control" name="end_date" type="date" id="end_date" required value="<?php echo e(isset($product) ? $product->end_date : old('end_date')); ?>" placeholder="Enter End Date">
                        <?php if($errors->has('end_date')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('end_date')); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">

                        <?php
                            isset($product) ? $pin_to_top = $product->pin_to_top : $pin_to_top = 0;
                        ?>
                        <input type="checkbox" name="pin_to_top" value="1" <?php echo e($pin_to_top == 1 ? 'checked' : ''); ?>>
                        <label for="pin_to_top" class="col-form-label ml-1">Pin To Top</label>
                    </div>

                    <div class="form-group">
                        <label for="images" class="col-form-label">Gallery</label>
                        <input class="form-control" multiple name="images[]" type="file" accept="image/*" id="images" <?php echo e(isset($product) ? '' : 'required'); ?>>
                        <?php if($errors->has('images.*')): ?>
                            <p class="help text-danger"><?php echo e($errors->first('images.*')); ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Gallery -->
                    <?php if(isset($product->images)): ?>
                    
                    <div class="row">
                        <?php $images = explode(', ', $product->images); ?>
                        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($image == null): ?>
                            <?php continue; ?>
                        <?php endif; ?>
                        <div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
                            <img
                                src="<?php echo e(asset('/uploads/products/'.$image)); ?>"
                                class="w-100 shadow-1-strong rounded mb-4 img-fluid"
                                alt="<?php echo e($product->name); ?>"
                            />
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <?php endif; ?>

                    <?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 3): ?>
                    
                    <button type="submit" name="submit" class="btn btn-primary mt-4 pr-4 pl-4">
                        <?php echo e(isset($product) ? 'Update' : 'Create'); ?>

                    </button>

                    <?php endif; ?>
                </form>

            </div>
        </div>

        
        <?php if(count($customersSubscriptions) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <div class="clearfix">
                    <h4 class="header-title float-left">
                        Customer Subscriptions
                    </h4>

                    <?php if(auth()->user()->role_id == 1): ?>
                    <button type="button" class="btn btn-danger end_participation float-right" data-product-name="<?php echo e($product->name); ?>" data-product-id="<?php echo e($product->id); ?>" title="End Participation">
                        <i class="fa fa-times-circle"></i> End Participation
                    </button>
					<?php endif; ?>

                </div>
                
                <div class="data-tables">
                    <table id="dataTable">
                        <thead class="bg-purple text-white">
                        <tr>
                            <th class="all" >CustomerID</th>
                            <th class="all" >Customer</th>
                            <th class="all" >Subscription Amount</th>
                            <th class="all" >Date Of Subscription</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $customersSubscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customerSubscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(url('admin/customers/'.$customerSubscription->user_id)); ?>" class="text-purple">
                                        <?php echo e($customerSubscription->user_id); ?>

                                    </a>
                                </td>
                                <td>
                                    <?php if(isset($customerSubscription->customer->avatar->avatar_url)): ?>
                                    <img src="<?php echo e(asset('/uploads/products/'.$customerSubscription->customer->avatar->avatar_url)); ?>"
                                        class="avatar avatar-sm me-3" alt="xd">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('backend/assets')); ?>/images/team-4.jpg"
                                            class="avatar avatar-sm me-3" alt="xd">
                                    <?php endif; ?>
                                    <?php echo e($customerSubscription->customer->firstname); ?> <?php echo e($customerSubscription->customer->lastname); ?>

                                </td>
                                <td><?php echo e($customerSubscription->subscription_amount); ?></td>
                                <td><?php echo e(date('d M Y', strtotime($customerSubscription->date_added))); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
            </div>
        </div>
        <?php endif; ?>

    </div>
    <!-- Textual inputs end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    tinymce.init({
      selector: '.description'
    });

    $(document).ready(function() {

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });


        // End Participation function
        $('.end_participation').on('click', function(e) {
            e.preventDefault();
            var id = $(this).data("product-id");
            var product_name = $(this).data("product-name");

            swal({
                title: "You will End Participation for "+ product_name,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            .then((willEnd) => {
                if (willEnd) {
                    var data = {
                        "_token" : $('input[name="csrf-token"]').val(),
                        "product_id" : id
                    };

                    // showing loading
                    $('.loader-container').removeClass('hidden');

                    var url = `<?php echo e(url("/admin/freegift_products/cancel_subscription/")); ?>`+ `/` +id;

                    $.ajax({
                    type: "POST",
                    url: url,
                    data:data,
                    success: function(response)
                    {
                        // remove loading
                        $('.loader-container').addClass('hidden');

                        var icon;
                        response.status == 1 ? icon = 'success' : icon = 'error';
                        swal(response.message, {
                            icon: icon,
                        })
                        .then((result) => {
                            location.reload();
                        });
                    }
                    });
                }

            });
        });


    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/freegift_products/form.blade.php ENDPATH**/ ?>