

<?php $__env->startSection('title', 'Customers'); ?>

<?php $__env->startSection('content'); ?>
<div class="loader-container hidden">
	<div class="loader-spinner"></div>
</div>

    <div class="col-12 mb-3" style="max-width: 97%; margin: 0 auto">
        <form action="<?php echo e(route('customers.filter')); ?>" method="POST">
            <?php echo e(csrf_field()); ?>


            <input type="hidden" name="filter" value="1">

            <div class="row bg-white py-4">
                <div class="col-3">
                    <div class="form-group">
                        <input type="number" class="form-control" name="phoneNumber" placeholder="Phone Number">
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <input type="number" class="form-control" name="id_customer" placeholder="Customer ID">
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <input type="text" class="form-control" name="firstname" placeholder="First Name">
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <input type="text" class="form-control" name="lastname" placeholder="Last Name">
                    </div>
                </div>
                <div class="col-3">
					<div class="form-group">
						<input type="text" class="form-control date" name="date_start" placeholder="Start Date">
					</div>
				</div>
                <div class="col-3">
					<div class="form-group">
						<input type="text" class="form-control date" name="date_end" placeholder="End Date">
					</div>
				</div>
                <div class="col-3">
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary" style="width: 100%; font-size: 14px">Filter</button>
                    </div>
                </div>
                <div class="col-3">
					<div class="form-group">
						<a href="<?php echo e(route('customers.index')); ?>" class="btn btn-danger" style="width: 100%; font-size: 14px">Reset</a>
					</div>
				</div>
            </div>

        </form>
    </div>

	<!-- data table start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">

                <div class="clearfix">
                    <h4 class="header-title float-left"><i class="fa fa-users custom-icon"></i> Customers Table</h4>
                </div>

                <div class="data-tables mt-4">
                    <table id="dataTable" class="table text-center" data-counter="<?php echo e($counter); ?>">
                        <thead class="bg-light text-capitalize">
                            <tr>
                                <th class="all">ID</th>
                                <th class="all">Fullname</th>
                                <th class="all">Governorate</th>
                                <th class="all">Phone</th>
                                <th class="all">Wallet</th>
                                <th class="all">Gender</th>
                                <th class="all">Date Of Join</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $__env->make('admin.customers.fetch-data-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            
                        </tbody>
                    </table>
                </div>

                <?php if($existingRows > $counter): ?>
				<a href="#" class="btn bg-purple text-white mt-3" id="load-more" data-existing-rows="<?php echo e($existingRows); ?>">Show More</a>
				<?php endif; ?>

            </div>
        </div>
    </div>
    <!-- data table end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
	<script type="text/javascript">

		$(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $("input.date").focus(function(){
                $(this).attr("type", "date");
            });

			
            // Load More Function
            $('#load-more').on('click', function(e) {
                e.preventDefault();

                var counter = $('table').data('counter');
                var existingRows = $(this).data('existingRows');

                if(existingRows < counter + 50) {
                    $(this).fadeOut();
                }


                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    } 
                });

                var data = {
                    counter : counter
                };

                var filter_requests = `<?php echo json_encode($filter_requests); ?>`;
                filter_requests = JSON.parse(filter_requests);

                for (let [key, value] of Object.entries(filter_requests)) {
                    data[key] = value;
                }

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(url('admin/customers')); ?>",
                    data: data,
                    success: function(data) {

                        $('table').data('counter', counter + 50);
                        
                        $('tbody').append(data);

                    }
                });

            });



		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/customers/index.blade.php ENDPATH**/ ?>