

<?php $__env->startSection('title', 'Recharge Amount'); ?>

<?php $__env->startSection('content'); ?>
    <!-- data table start -->

	<div class="col-12 mb-3" style="max-width: 97%; margin: 0 auto">
		<form action="<?php echo e(route('recharge_amount.filter')); ?>" method="GET">
			<?php echo e(csrf_field()); ?>


			<div class="row bg-white py-4">
				<div class="col-2">
					<div class="form-group">
						<select name="state" id="state" class="form-control">
							<option disabled selected>State</option>
							<option value="5">Accepted</option>
							<option value="0">Pending</option>
							<option value="10">Rejected</option>
						</select>
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<select name="payment_method" id="payment_method" class="form-control">
							<option disabled selected>Payment Method</option>
							<option value="card">Card</option>
							<option value="wallet">Wallet</option>
							<option value="koisk">koisk</option>
						</select>
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<input type="text" class="form-control date" name="min_date" placeholder="Date Start">
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<input type="text" class="form-control date" name="max_date" placeholder="Date End">
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<button type="submit" class="btn btn-primary">Filter</button>
					</div>
				</div>

				<div class="col-9 mt-2">
					<div class="alert alert-primary" role="alert">
						Total Recharge Amount is <span class="total"><?php echo e($sum); ?> EGP</span> of <span class="record"><?php echo e($existingRows); ?></span> Records
					</div>
				</div>
				
			</div>
	
		</form>
	</div>
	
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
                <div class="data-tables mt-4">
                    <table id="dataTable" class="text-center" data-counter="<?php echo e($counter); ?>">
                        <thead class="bg-light text-capitalize">
                            <tr>
                                <th class="all">ID</th>
                                <th class="all">Recharge Amount</th>
                                <th class="all">Payment Method</th>
                                <th class="all">State</th>
                                <th class="all">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $__env->make('admin.recharge_amount.fetch-data-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            
                        </tbody>
                    </table>
                </div>

				<?php if($existingRows > $counter): ?>
				<a href="#" class="btn bg-purple text-white mt-3" id="load-more" data-existing-rows="<?php echo e($existingRows); ?>">Show More</a>
				<?php endif; ?>

            </div>
        </div>
    </div>
    <!-- data table end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>

		$(document).ready(function() {
			$("input.date").focus(function(){
				$(this).attr("type", "date");
			});

			// Load More Function
			$('#load-more').on('click', function(e) {
				e.preventDefault();

				var counter = $('table').data('counter');
				var existingRows = $(this).data('existingRows');

				if(existingRows < counter + 50) {
					$(this).fadeOut();
				}

				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					} 
				});

				$.ajax({
					type: "POST",
					url: "<?php echo e(Route('recharge_amount.loadMore')); ?>",
					data: {counter: counter},
					success: function(data) {

						$('table').data('counter', counter + 50);
						
						$('tbody').append(data);

					}
				});

			});

		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/recharge_amount/index.blade.php ENDPATH**/ ?>