

<?php $__env->startSection('title', 'products Participation'); ?>

<?php $__env->startSection('content'); ?>
    <!-- data table start -->

	<div class="col-12 mb-3" style="max-width: 97%; margin: 0 auto">
		<form action="<?php echo e(route('products_subscriptions.filter')); ?>" method="GET">
			<?php echo e(csrf_field()); ?>


			<div class="row bg-white py-4">
				<div class="col-4">
					<div class="form-group">
						<input type="number" class="form-control" min="0" name="min_price" placeholder="Min Price">
					</div>
				</div>
				<div class="col-4">
					<div class="form-group">
						<input type="number" class="form-control" min="0" name="max_price" placeholder="Max Price">
					</div>
				</div>
				<div class="col-4">
					<div class="form-group">
						<button type="submit" class="btn btn-primary">Filter</button>
					</div>
				</div>

				<?php if(isset($sum)): ?>
				<div class="col-9 mt-2">
					<div class="alert alert-primary" role="alert">
						Total Product Participation Amount is <span class="total"><?php echo e($sum); ?> EGP</span> of <span class="record"><?php echo e($count); ?></span> Products
					</div>
				</div>
				<?php endif; ?>
				
			</div>
	
		</form>
	</div>
	
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
                <div class="data-tables mt-4">
                    <table id="dataTable" class="text-center" data-counter="<?php echo e($counter); ?>">
                        <thead class="bg-light text-capitalize">
                            <tr>
                                <th class="all">Date</th>
                                <th class="all">Name</th>
                                <th class="all">Price</th>
                                <th class="all">Total Participation Amount</th>
                                <th class="all">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $__env->make('admin.products_subscriptions.fetch-data-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            
                        </tbody>
                    </table>
                </div>

				<?php if($existingRows > $counter): ?>
				<a href="#" class="btn bg-purple text-white mt-3" id="load-more" data-existing-rows="<?php echo e($existingRows); ?>">Show More</a>
				<?php endif; ?>

            </div>
        </div>
    </div>
    <!-- data table end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>

		$(document).ready(function() {

			// Load More Function
			$('#load-more').on('click', function(e) {
				e.preventDefault();

				var counter = $('table').data('counter');
				var existingRows = $(this).data('existingRows');

				if(existingRows < counter + 50) {
					$(this).fadeOut();
				}


				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					} 
				});

				$.ajax({
					type: "POST",
					url: "<?php echo e(Route('products_subscriptions.loadMore')); ?>",
					data: {counter: counter},
					success: function(data) {

						$('table').data('counter', counter + 50);
						
						$('tbody').append(data);

					}
				});

			});

		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/products_subscriptions/index.blade.php ENDPATH**/ ?>