<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo $__env->yieldContent('title', 'Dashboard'); ?></title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('backend/assets/images/favicon.png')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/bootstrap.min.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/font-awesome.min.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/themify-icons.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/metisMenu.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/owl.carousel.min.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/slicknav.min.css')); ?>" type="text/css">
    
    <link rel="stylesheet" href="https://www.amcharts.com/lib/3/plugins/export/export.css" type="text/css" media="all" />
    
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/typography.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/default-css.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/styles.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/assets/css/responsive.css')); ?>" type="text/css">

    <!-- Tinymce Script -->
    <script src="https://cdn.tiny.cloud/1/z11c2h50n7nrfmryazjs4xzib8487mkjns9jlwpqns4wd715/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>

    <!-- Start datatable css -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.18/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.jqueryui.min.css">

    <script src="<?php echo e(asset('backend/assets/js/vendor/modernizr-2.8.3.min.js')); ?>"></script>

    <?php echo $__env->yieldContent('styles'); ?>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
</head>
<body>

    <!--[if lt IE 8]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
    <![endif]-->
    <!-- preloader area start -->
    <div id="preloader">
        <div class="loader"></div>
    </div>
    <!-- preloader area end -->
    <!-- page container area start -->
    <div class="page-container">

        <!-- sidebar menu area start -->
        <div class="sidebar-menu">
            <div class="sidebar-header">
                <div class="logo py-2">
                    <a href="<?php echo e(url('admin')); ?>"><?php echo e(auth()->user()->role->name); ?></a>
                </div>
            </div>
            <div class="main-menu">
                <div class="menu-inner">
                    <nav>
                        <ul class="metismenu" id="menu">
                            <li>
                                <a href="<?php echo e(url('admin')); ?>" aria-expanded="true"><i class="ti-dashboard"></i><span>dashboard</span></a>
                            </li>

                            <?php if(auth()->user()->role_id == 1): ?>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-codiepie"></i><span>Categories</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('categories.create')); ?>"><i class="fa fa-plus"></i> Add Category</a></li>
                                    <li><a href="<?php echo e(route('categories.index')); ?>"><i class="fa fa-eye"></i> View Categories</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-product-hunt"></i><span>Products</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('products.create')); ?>"><i class="fa fa-plus"></i> Add Product</a></li>
                                    <li><a href="<?php echo e(route('products.index')); ?>"><i class="fa fa-eye"></i> View Products</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-gift"></i><span>Freegift Products</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('freegift_products.create')); ?>"><i class="fa fa-plus"></i> Add Free Product</a></li>
                                    <li><a href="<?php echo e(route('freegift_products.index')); ?>"><i class="fa fa-eye"></i> View Free Products</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="<?php echo e(route('recharge_amount')); ?>"><i class="fa fa-eye"></i> Recahrge Amount</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('products_subscriptions')); ?>"><i class="fa fa-eye"></i> Products Participation</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('customers.index')); ?>"><i class="fa fa-users"></i> Our Customers</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('customers.notificationsPage')); ?>"><i class="fa fa-paper-plane"></i> Send Notifications</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('donations.index')); ?>"><i class="fa fa-gift"></i> Donations</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('winners.index')); ?>"><i class="fa fa-trophy"></i> Winners</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('refundrequest.index')); ?>"><i class="fa fa-undo"></i> Refund Request</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('transaction_verifier')); ?>"><i class="fa fa-money"></i> Transaction verifier</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('share_data.show')); ?>"><i class="fa fa-share-alt"></i> Share Data</a></li>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-picture-o"></i><span>HomePage Slider</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('homePageSlider.create')); ?>"><i class="fa fa-plus"></i> Add HomePage Slider</a></li>
                                    <li><a href="<?php echo e(route('homePageSlider.index')); ?>"><i class="fa fa-eye"></i> View HomePage Slider</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-gift"></i><span>Copouns</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('copouns.create')); ?>"><i class="fa fa-plus"></i> Add copoun</a></li>
                                    <li><a href="<?php echo e(route('copouns.index')); ?>"><i class="fa fa-eye"></i> View copouns</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-user"></i><span>Administrative Users</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('users.create')); ?>"><i class="fa fa-eye"></i> Add User</a></li>
                                    <li><a href="<?php echo e(route('users.index')); ?>"><i class="fa fa-eye"></i> View Users</a></li>
                                </ul>
                            </li>

                            <?php elseif(auth()->user()->role_id == 2): ?>
                            <li>
                                <a href="<?php echo e(route('recharge_amount')); ?>"><i class="fa fa-eye"></i> Recahrge Amount</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('products_subscriptions')); ?>"><i class="fa fa-eye"></i> Products Participation</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('donations.index')); ?>"><i class="fa fa-gift"></i> Donations</a></li>
                            </li>
                            
                            <?php elseif(auth()->user()->role_id == 3): ?>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-product-hunt"></i><span>Products</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('products.create')); ?>"><i class="fa fa-eye"></i> Add Product</a></li>
                                    <li><a href="<?php echo e(route('products.index')); ?>"><i class="fa fa-eye"></i> View Products</a></li>
                                </ul>
                                <li>
                                    <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-gift"></i><span>Freegift Products</span></a>
                                    <ul class="collapse">
                                        <li><a href="<?php echo e(route('freegift_products.create')); ?>"><i class="fa fa-plus"></i> Add Free Product</a></li>
                                        <li><a href="<?php echo e(route('freegift_products.index')); ?>"><i class="fa fa-eye"></i> View Free Products</a></li>
                                    </ul>
                                </li>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-picture-o"></i><span>HomePage Slider</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('homePageSlider.create')); ?>"><i class="fa fa-plus"></i> Add HomePage Slider</a></li>
                                    <li><a href="<?php echo e(route('homePageSlider.index')); ?>"><i class="fa fa-eye"></i> View HomePage Slider</a></li>
                                </ul>
                            </li>

                            <?php elseif(auth()->user()->role_id == 4): ?>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-codiepie"></i><span>Categories</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('categories.index')); ?>"><i class="fa fa-eye"></i> View Categories</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-product-hunt"></i><span>Products</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('products.index')); ?>"><i class="fa fa-eye"></i> View Products</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-gift"></i><span>Freegift Products</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('freegift_products.index')); ?>"><i class="fa fa-eye"></i> View Free Products</a></li>
                                </ul>
                            </li>
                            <li>
                                <a href="<?php echo e(route('recharge_amount')); ?>"><i class="fa fa-eye"></i> Recahrge Amount</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('products_subscriptions')); ?>"><i class="fa fa-eye"></i> Products Participation</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('customers.index')); ?>"><i class="fa fa-users"></i> Our Customers</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('donations.index')); ?>"><i class="fa fa-gift"></i> Donations</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('winners.index')); ?>"><i class="fa fa-trophy"></i> Winners</a></li>
                            </li>
                            <li>
                                <a href="<?php echo e(route('refundrequest.index')); ?>"><i class="fa fa-undo"></i> Refund Request</a></li>
                            </li>
                            <li>
                                <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-picture-o"></i><span>HomePage Slider</span></a>
                                <ul class="collapse">
                                    <li><a href="<?php echo e(route('homePageSlider.index')); ?>"><i class="fa fa-eye"></i> View HomePage Slider</a></li>
                                </ul>
                            </li>
                            <?php endif; ?>
                            
                            
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
        <!-- sidebar menu area end -->

        <!-- main content area start -->
        <div class="main-content">
            <!-- header area start -->
            <div class="header-area">
                <div class="row align-items-center">
                    <!-- nav and search button -->
                    <div class="col-md-6 col-sm-8 clearfix">
                        <div class="nav-btn pull-left">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <div class="search-box pull-left">
                            <form action="#">
                                <input type="text" name="search" placeholder="Search..." required>
                                <i class="ti-search"></i>
                            </form>
                        </div>
                    </div>
                    <!-- profile info & task notification -->
                    <div class="col-md-6 col-sm-4 clearfix">
                        <ul class="notification-area pull-right">
                            <li id="full-view"><i class="ti-fullscreen"></i></li>
                            <li id="full-view-exit"><i class="ti-zoom-out"></i></li>
                            <li class="dropdown">
                                <i class="ti-bell dropdown-toggle" data-toggle="dropdown">
                                    <span>1</span>
                                </i>
                                <div class="dropdown-menu bell-notify-box notify-box">
                                    <span class="notify-title">You have 1 new notifications <a href="#">view all</a></span>
                                    <div class="nofity-list">
                                        <a href="#" class="notify-item">
                                            <div class="notify-thumb"><i class="ti-key btn-danger"></i></div>
                                            <div class="notify-text">
                                                <p>You have Logged In</p>
                                                <span>Just Now</span>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </li>
                          
                            <li class="settings-btn">
                                <i class="ti-settings"></i>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- header area end -->
            <!-- page title area start -->
            <div class="page-title-area">
                <div class="row align-items-center">
                    <div class="col-sm-6">
                        <div class="breadcrumbs-area clearfix">
                            <h4 class="page-title pull-left">Dashboard</h4>
                            <ul class="breadcrumbs pull-left">
                                <li><a href="<?php echo e(url('admin')); ?>">Home</a></li>
                                <li><span>Dashboard</span></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-6 clearfix">
                        <div class="user-profile pull-right">
                            <h4 class="user-name dropdown-toggle" data-toggle="dropdown">Hello <?php echo e(Auth::user()->name); ?> <i class="fa fa-angle-down"></i></h4>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        <?php echo e(__('Logout')); ?>

                                </a>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- page title area end -->
            <div class="main-content-inner">
                
                <div class="row mt-5">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
        <!-- main content area end -->
        <!-- footer area start-->
        <footer>
            <div class="footer-area">
                <p>© All Rights Reserved</p>
            </div>
        </footer>
        <!-- footer area end-->
    </div>
    <!-- page container area end -->
    <!-- offset area start -->
    <div class="offset-area">
        <div class="offset-close"><i class="ti-close"></i></div>
        <ul class="nav offset-menu-tab">
            <li><a class="active" data-toggle="tab" href="#activity">Activity</a></li>
            <li><a data-toggle="tab" href="#settings">Settings</a></li>
        </ul>
        <div class="offset-content tab-content">
            <div id="activity" class="tab-pane fade in show active">
                <div class="recent-activity">
                    
                    <div class="timeline-task">
                        <div class="icon bg2">
                            <i class="fa fa-check"></i>
                        </div>
                        <div class="tm-title">
                            <h4>You'r Logged In</h4>
                            <span class="time"><i class="ti-time"></i>7 Minutes Ago</span>
                        </div>
                        <p>Lorem ipsum dolor sit amet consectetur.
                        </p>
                    </div>
                    
                </div>
            </div>
            <div id="settings" class="tab-pane fade">
                <div class="offset-settings">
                    <h4>General Settings</h4>
                    <div class="settings-list">
                        <div class="s-settings">
                            <div class="s-sw-title">
                                <h5>Notifications</h5>
                                <div class="s-swtich">
                                    <input type="checkbox" id="switch1" />
                                    <label for="switch1">Toggle</label>
                                </div>
                            </div>
                            <p>Keep it 'On' When you want to get all the notification.</p>
                        </div>
                        <div class="s-settings">
                            <div class="s-sw-title">
                                <h5>Show recent activity</h5>
                                <div class="s-swtich">
                                    <input type="checkbox" id="switch2" />
                                    <label for="switch2">Toggle</label>
                                </div>
                            </div>
                            <p>The for attribute is necessary to bind our custom checkbox with the input.</p>
                        </div>
                        <div class="s-settings">
                            <div class="s-sw-title">
                                <h5>Show your emails</h5>
                                <div class="s-swtich">
                                    <input type="checkbox" id="switch3" />
                                    <label for="switch3">Toggle</label>
                                </div>
                            </div>
                            <p>Show email so that easily find you.</p>
                        </div>
                        <div class="s-settings">
                            <div class="s-sw-title">
                                <h5>Show Task statistics</h5>
                                <div class="s-swtich">
                                    <input type="checkbox" id="switch4" />
                                    <label for="switch4">Toggle</label>
                                </div>
                            </div>
                            <p>The for attribute is necessary to bind our custom checkbox with the input.</p>
                        </div>
                        <div class="s-settings">
                            <div class="s-sw-title">
                                <h5>Notifications</h5>
                                <div class="s-swtich">
                                    <input type="checkbox" id="switch5" />
                                    <label for="switch5">Toggle</label>
                                </div>
                            </div>
                            <p>Use checkboxes when looking for yes or no answers.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- jquery latest version -->
    <script src="<?php echo e(asset('backend/assets/js/vendor/jquery-2.2.4.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('backend/assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/jquery.slimscroll.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/jquery.slicknav.min.js')); ?>"></script>

    <!-- start chart js -->
    
    <!-- start highcharts js -->
    
    <!-- start zingchart js -->
    
    

    <!-- Start datatable js -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.3/js/responsive.bootstrap.min.js"></script>

    
    
    
    
    
    <script src="<?php echo e(asset('backend/assets/js/plugins.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/assets/js/scripts.js')); ?>"></script>

    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH E:\xampp\htdocs\bgneh\resources\views/layouts/dashboard.blade.php ENDPATH**/ ?>