

<?php $__env->startSection('title', 'Refund Requests'); ?>

<?php $__env->startSection('content'); ?>
<div class="loader-container hidden">
	<div class="loader-spinner"></div>
</div>

    <div class="col-12 mb-3" style="max-width: 97%; margin: 0 auto">
        <form action="<?php echo e(route('refundrequest.filter')); ?>" method="POST">
            <?php echo e(csrf_field()); ?>


            <input type="hidden" name="filter" value="1">

            <div class="row bg-white py-4">
                <div class="col-3">
                    <div class="form-group">
                        <input type="number" class="form-control" name="phoneNumber" placeholder="Phone Number">
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <input type="number" class="form-control" name="id_customer" placeholder="Customer ID">
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <input type="text" class="form-control" name="firstname" placeholder="First Name">
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <input type="text" class="form-control" name="lastname" placeholder="Last Name">
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <select name="status" class="form-control">
                            <option value="" disabled selected>Choose Status</option>
                            <option value="1">Complete</option>
                            <option value="-1">Cancelled</option>
                            <option value="0">Pending</option>
                        </select>
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <button type="submit" class="btn btn-primary" style="width: 100%; font-size: 14px">Filter</button>
                    </div>
                </div>
                <div class="col-3">
                    <div class="form-group">
                        <a href="<?php echo e(route('refundrequest.index')); ?>" class="btn btn-danger" style="width: 100%; font-size: 14px">Reset</a>
                    </div>
                </div>
            </div>

        </form>
    </div>

	<!-- data table start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
                <div class="data-tables mt-4">
                    <table id="dataTable" class="text-center" data-counter="<?php echo e($counter); ?>">
                        <thead class="bg-light text-capitalize">
                            <tr>
                                <th class="all">Customer</th>
                                <th class="all">Refund Amount</th>
                                <th class="all">Status</th>
                                <th class="all">Customer Wallet</th>
                                <th class="all">Bank Info</th>
                                <th class="all">Date</th>
                                <?php if(auth()->user()->role_id == 1): ?>
                                <th class="all">Refund</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $__env->make('admin.refund_request.fetch-data-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </tbody>
                    </table>
                </div>

                <?php if($existingRows > $counter): ?>
				<a href="#" class="btn bg-purple text-white mt-3" id="load-more" data-existing-rows="<?php echo e($existingRows); ?>">Show More</a>
				<?php endif; ?>

            </div>
        </div>
    </div>
    <!-- data table end -->

    <!-- bank modal start -->
    <div class="modal fade" id="modal-bank" tabindex="-1" role="dialog" aria-labelledby="modal-bank-label" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modal-bank-label">Bank Info</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <!-- bank modal end -->


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
	<script type="text/javascript">

		$(document).ready(function() {
			$.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
			});
			

            // Refund Function
			$('#dataTable').on('click', '.refund-btn', function(e) {
				e.preventDefault();
				var refund_request_id = $(this).data("refund-request-id"),
                    user_id = $(this).data("user-id");
				swal({
                    title: "Are you sure?",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
				})
				.then((willDelete) => {
                    if (willDelete) {
                            var data = {
                                "_token" : $('input[name="csrf-token"]').val(),
                                "refund_request_id" : refund_request_id,
                                "user_id" : user_id
                            };
                            $.ajax({
                                type: "POST",
                                url: "<?php echo e(route('refundtransaction')); ?>",
                                data:data,
                                success: function(response)
                                {
                                    if(response.status == 1) {
                                        swal(response.message, {
                                            icon: "success",
                                        })
                                        .then((result) => {
                                            location.reload();
                                        });
                                    } else {
                                        swal(response.message, {
                                            icon: "error",
                                        })
                                        .then((result) => {
                                            location.reload();
                                        });
                                    }
                                    
                                }
                            });
                    }

				});
			});

            // Cancel Refund Function
			$('#dataTable').on('click', '.cancel-btn', function(e) {
				e.preventDefault();
				var refund_request_id = $(this).data("refund-request-id"),
                refund_amount = $(this).data("refund-request-amount"),
                    user_id = $(this).data("user-id");
				swal({
                    title: "Are you sure?",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
				})
				.then((willDelete) => {
                    if (willDelete) {
                            var data = {
                                "_token" : $('input[name="csrf-token"]').val(),
                                "refund_request_id" : refund_request_id,
                                "refund_amount" : refund_amount,
                                "user_id" : user_id
                            };
                            $.ajax({
                                type: "POST",
                                url: "<?php echo e(route('cancelrefundtransaction')); ?>",
                                data:data,
                                success: function(response)
                                {
                                    if(response.status == 1) {
                                        swal(response.message, {
                                            icon: "success",
                                        })
                                        .then((result) => {
                                            location.reload();
                                        });
                                    } else {
                                        swal(response.message, {
                                            icon: "error",
                                        })
                                        .then((result) => {
                                            location.reload();
                                        });
                                    }
                                    
                                }
                            });
                    }

				});
			});

            // Load More Function
            $('#load-more').on('click', function(e) {
                e.preventDefault();

                var counter = $('table').data('counter');
                var existingRows = $(this).data('existingRows');

                if(existingRows < counter + 50) {
                    $(this).fadeOut();
                }


                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    } 
                });

                var data = {
                    counter : counter
                };

                var filter_requests = `<?php echo json_encode($filter_requests); ?>`;
                filter_requests = JSON.parse(filter_requests);

                for (let [key, value] of Object.entries(filter_requests)) {
                    data[key] = value;
                }

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(url('admin/refundrequest')); ?>",
                    data: data,
                    success: function(data) {

                        $('table').data('counter', counter + 50);
                        
                        console.log(data);
                        
                        $('tbody').append(data);

                    }
                });

            });

            // Show Bank info modal
            $(document).on('click', '.show-bank', function(e) {
                e.preventDefault();

                var refund_object = $(this).data('object');

                try {
                    $('#modal-bank .modal-body').html('');
                    for (var key in refund_object) {
                        var item = `<div class="item"><i class="fa fa-clipboard" title="Copy!"></i> ${key}: <span>${refund_object[key]}</span></div>`;
                        $('#modal-bank .modal-body').append(item);
                    }
                } catch (error) {
                    var item = `<div class="item"> Error: <span>${error}</span></div>`;
                }
                $('#modal-bank').modal('show');
            });


		});
		
		// Copy To clipboard
        $(document).on('click', '#modal-bank .item i', function() {
            var textToCopy = $(this).siblings('span').text();
            
            copyToClipboard(textToCopy);
            
        });
        
        function copyToClipboard(text) {
            var status = 0;
            if (navigator.clipboard) {
                navigator.clipboard.writeText(text).then(function() {
                    status = 1;
                    
                    swal('Copied to clipboard !', {
                        icon: "success",
                        timer: 1000,
                    });
                
                }, function() {
                    console.error('Could not copy text to clipboard');
                });
            } else {
                console.error('Clipboard API not supported');
            }
        }

    
	</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/refund_request/index.blade.php ENDPATH**/ ?>