

<?php $__env->startSection('title', 'Products'); ?>

<?php $__env->startSection('content'); ?>

<div class="loader-container hidden">
	<div class="loader-spinner"></div>
</div>

    <!-- data table start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
                <div class="clearfix">
                    <h4 class="header-title float-left"><i class="fa fa-money custom-icon"></i> Products Table</h4>

					<?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 3): ?>
					<a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary float-right">
                        <i class="fa fa-plus"></i>
                        New Product
                    </a>
					<?php endif; ?>
					
					<?php if(auth()->user()->role_id == 1 || auth()->user()->role_id == 4): ?>
					<a href="<?php echo e(route('nearToCloseProducts')); ?>" class="btn btn-primary float-right mr-4">
                        <i class="fa fa-product-hunt"></i>
                        Near to close Product
                    </a>
					<?php endif; ?>
                </div>

				
				<div class="data-tables mt-4">
					<table id="dataTable" class="table text-center" data-counter="<?php echo e($counter); ?>">
						<thead class="bg-light text-capitalize">
							<tr>
								<th class="all">Category</th>
								<th class="all">ID</th>
								<th class="all">Name</th>
								<th class="all">Price</th>
								<?php if(isset($products[0]->subscribtion_progress)): ?>
								<th class="all">Subscribtion progress</th>
								<?php endif; ?>
								<th class="all">Status</th>
								<th class="all">Action</th>
							</tr>
						</thead>
						<tbody>
							<?php echo $__env->make('admin.products.fetch-data-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
						</tbody>
					</table>
				</div>
				<!-- table end -->

				<?php if($existingRows > $counter): ?>
				<a href="#" class="btn bg-purple text-white mt-3" id="load-more" data-existing-rows="<?php echo e($existingRows); ?>">Show More</a>
				<?php endif; ?>

            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
	<script type="text/javascript">

		$(document).ready(function() {
			$.ajaxSetup({
			    headers: {
			        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			    }
			});

			// Delete function
			$('.servideletebtn').on('click', function(e) {
				e.preventDefault();
				var id = $(this).closest("tr").find('.deleted_id').val();
				// alert(id);
				swal({
				  title: "Are you sure?",
				  text: "Once deleted, you will not be able to recover this Record!",
				  icon: "warning",
				  buttons: true,
				  dangerMode: true,
				})
				.then((willDelete) => {
				  if (willDelete) {
				  		var data = {
				  			"_token" : $('input[name="csrf-token"]').val(),
				  			"id" : id
				  		};
				  	      $.ajax({
					        type: "GET",
					        url: 'products/delete/'+id,
					        data:data,
					        success: function(response)
					        {
					          	swal(response.status, {
							      icon: "success",
							    })
							    .then((result) => {
							    	location.reload();
							    });
					        }
					      });
				  }

				});
			});

			// Activation Function
			$("#dataTable").on('click', '.act-btn', function(e) {
				e.preventDefault();

				if($(this).hasClass('activate')) {

					var is_active = 1;
					
				} else {
					var is_active = 0;
				}

				var id = $(this).closest("tr").find('.deleted_id').val();

				var data = {
					"_token" : $('input[name="csrf-token"]').val(),
				};

				// showing loading
				$('.loader-container').removeClass('hidden');

				$.ajax({
					type: "GET",
					url: 'product_activation/'+id+'/'+is_active,
					data: data,
					success: function(response)
					{

						// remove loading
						$('.loader-container').addClass('hidden');

						if(response.status == 1) {
							swal(response.message, {
								icon: "success",
							})
							.then((result) => {
								location.reload();
							});

						} else {
							swal(response.message, {
								icon: "warning",
							})
							.then((result) => {
								location.reload();
							});
						}
						
					}
				});
			});

			// Load More Function
			$('#load-more').on('click', function(e) {
				e.preventDefault();

				var counter = $('table').data('counter');
				var existingRows = $(this).data('existingRows');

				if(existingRows < counter + 50) {
					$(this).fadeOut();
				}


				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					} 
				});

				$.ajax({
					type: "POST",
					url: "<?php echo e(Route('products.loadMore')); ?>",
					data: {counter: counter},
					success: function(data) {


						$('table').data('counter', counter + 50);
						
						$('tbody').append(data);

						// $('#dataTable').DataTable().ajax.reload();

					}
				});

			});

		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/products/index.blade.php ENDPATH**/ ?>