

<?php $__env->startSection('title', 'Send Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="loader-container hidden">
	<div class="loader-spinner"></div>
</div>


	<div class="col-12 mb-3" style="max-width: 97%; margin: 0 auto">
		<form action="<?php echo e(url('admin/notifications')); ?>" method="POST">
			<?php echo e(csrf_field()); ?>


			<input type="hidden" name="filter" value="1">

			<div class="row bg-white py-4">
				<div class="col-3">
					<div class="form-group">
						<select name="id_gender" id="id_gender" class="form-control">
							<option disabled selected>Gender</option>
							<option value="Male">Male</option>
							<option value="Female">Female</option>
						</select>
					</div>
				</div>
				<div class="col-3">
					<div class="form-group">
						<select name="govern" id="govern" class="form-control">
							<option disabled selected>Governorate</option>
							<?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $governorate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option value="<?php echo e($governorate['governorate_name_en']); ?>"><?php echo e($governorate['governorate_name_en']); ?> - <?php echo e($governorate['governorate_name_ar']); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
					</div>
				</div>
				<div class="col-3">
					<div class="form-group">
						<input type="number" class="form-control" name="phoneNumber" placeholder="Phone">
					</div>
				</div>
				<div class="col-3">
					<div class="form-group">
						<input type="email" class="form-control" name="email" placeholder="Email">
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<input type="number" class="form-control" name="min_wallet" placeholder="Min Wallet">
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<input type="number" class="form-control" name="max_wallet" placeholder="Max Wallet">
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<input type="number" min="1" class="form-control" name="min_age" placeholder="Min Age">
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<input type="number" min="1" class="form-control" name="max_age" placeholder="Max Age">
					</div>
				</div>
				<div class="col-4">
					<div class="form-group">
						<input type="text" class="form-control date" name="date_add" placeholder="Date of join">
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<button type="submit" class="btn btn-primary" style="width: 100%; font-size: 14px">Filter</button>
					</div>
				</div>
				<div class="col-2">
					<div class="form-group">
						<a href="<?php echo e(route('customers.notificationsPage')); ?>" class="btn btn-danger" style="width: 100%; font-size: 14px">Reset</a>
					</div>
				</div>

			</div>
	
		</form>
	</div>
	<div class="col-12 mb-3" style="max-width: 97%; margin: 0 auto">
		<form>
			<?php echo e(csrf_field()); ?>


			<div class="row bg-white py-4">
				<div class="col-5">
					<div class="form-group">
						<input type="text" class="form-control" name="notification_title" placeholder="Notification Title">
					</div>
				</div>
				<div class="col-3">
					<div class="form-group">
						<input type="text" class="form-control datetime" name="scheduled_date" placeholder="Scheduled Date">
					</div>
				</div>
				<?php if(count($filter_requests) > 1 && isset($filter_requests['filter']) ): ?>
				<div class="col-2">
					<div class="form-group" style="line-height: 45px;">
						<input type="checkbox" name="all_filtered"  id="all_filtered">
						<label for="all_filtered">All Filtered ?</label>
					</div>
				</div>
				<?php endif; ?>
				<div class="col-2">
					<div class="form-group">
						<button type="submit" id="send-notifications" class="btn btn-danger" style="font-size: 14px">Send Notifications</button>
					</div>
				</div>
			</div>
	
		</form>
	</div>
	

	<!-- data table start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
				<table class="table text-center mt-4" data-counter="<?php echo e($counter); ?>">
					<thead class="bg-light text-capitalize">
						<tr>
							<th class="all">ID</th>
							<th class="all">Fullname</th>
							<th class="all">Governorate</th>
							<th class="all">Phone</th>
							<th class="all">Wallet</th>
							<th class="all">Age</th>
							<th class="all">Gender</th>
							<th class="all">All <input class="ml-2 toggle-checkbox" type="checkbox" name="toggle"></th>
						</tr>
					</thead>
					<tbody>
						<?php echo $__env->make('admin.customers.fetch-n-data-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</tbody>
				</table>
                
				<?php if($existingRows > $counter): ?>
				<a href="#" class="btn bg-purple text-white mt-3" id="load-more" data-existing-rows="<?php echo e($existingRows); ?>">Show More</a>
				<?php endif; ?>

            </div>
        </div>
    </div>
    <!-- data table end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
	<script>

		// ***** change input type to date function
		$("input.date").focus(function(){
			$(this).attr("type", "date");
		});
		$("input.datetime").focus(function(){
			$(this).attr("type", "datetime-local");
		});

		// ***** toggle check all rows function
		$(".toggle-checkbox").on('change', function() {
			if($(this).hasClass('checked')) {
				$('.toggle-checkbox').removeClass('checked');
				$('input.checkbox').prop('checked', false);
			} else {
				$('.toggle-checkbox').addClass('checked');
				$('input.checkbox').prop('checked', true);
			}
		});

		// ***** Send Notification Function
		$('#send-notifications').on('click', function(e) {
			e.preventDefault();

			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				} 
			});

			var notification_title = $('input[name="notification_title"]').val();
			var scheduled_date = $('input[name="scheduled_date"]').val();

			if(notification_title == '') {

				swalAlert('Please fill in the required fields !', 0);

			} else {

				var all_filtered = $('input[name="all_filtered"]').is(":checked");
				var checkedUsers = $('input[name="customer_id"]:checked');
				var usersIds = [];
				
				checkedUsers.each(function() {
					usersIds.push($(this).attr('data-id'));
				});

				var data = {
					"all_filtered": all_filtered,
					"users_array": usersIds,
					"notification_title": notification_title,
					"scheduled_date": scheduled_date
				};

				if(all_filtered) {
					// => Send all filter params if all_filtered is true
					var filter_requests = `<?php echo json_encode($filter_requests); ?>`;
					filter_requests = JSON.parse(filter_requests);

					for (let [key, value] of Object.entries(filter_requests)) {
						data[key] = value;
					}
				}

				// showing loading
				$('.loader-container').removeClass('hidden');

				$.ajax({
					type: "POST",
					url: "<?php echo e(Route('customers.send.notifications')); ?>",
					data: data,
					success: function(response) {

						console.log(response);
						
						// remove loading
						$('.loader-container').addClass('hidden');
						
						if(response.status == 1) {
							swalAlert(response.message, 1, 'reload');
						} else {
							swalAlert(response.message, 0);
						}
					}
				});

			}

		});
		// ***** End Send Notification Function

		// Load More Function
		$('#load-more').on('click', function(e) {
			e.preventDefault();

			var counter = $('table').data('counter');
			var existingRows = $(this).data('existingRows');

			if(existingRows < counter + 50) {
				$(this).fadeOut();
			}


			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				} 
			});

			var data = {
				counter : counter
			};

			var filter_requests = `<?php echo json_encode($filter_requests); ?>`;
			filter_requests = JSON.parse(filter_requests);

			for (let [key, value] of Object.entries(filter_requests)) {
				data[key] = value;
			}

			$.ajax({
				type: "POST",
				url: "<?php echo e(url('admin/notifications')); ?>",
				data: data,
				success: function(data) {

					$('table').data('counter', counter + 50);
					
					$('tbody').append(data);

				}
			});

		});


		function swalAlert(message, status, reload = '') {
            var icon;
            status == 1 ? icon = 'success' : icon = 'error';

            if(reload) {

                swal(message, {
                        icon: icon,
                    })
                    .then((result) => {
                        location.reload();
                });

            } else {
				swal({
					icon: icon,
					title: message,
				});
			}
        }

	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/customers/send-notifications.blade.php ENDPATH**/ ?>