

<?php $__env->startSection('title', 'HomePage Slider'); ?>

<?php $__env->startSection('content'); ?>
    <!-- data table start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">
                <div class="clearfix">
                    <h4 class="header-title float-left"><i class="fa fa-picture-o custom-icon"></i> HomePage Slider Table</h4>
                </div>
                <div class="data-tables mt-4">
                    <table id="dataTable" class="text-center">
                        <thead class="bg-light text-capitalize">
                            <tr>
                                <th class="all">id</th>
                                <th class="all">Image</th>
                                <th class="all">Status</th>
                                <th class="all">Date created</th>
                                <th class="all">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $homePageSliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $homePageSlider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php 
                                    $path = explode('/', $homePageSlider->path);
                                    isset($path[3]) ? $img = $path[3] : $img = '';
                                ?>
                                <tr>
                                    <input type="hidden" class="deleted_id" value="<?php echo e($homePageSlider->id); ?>">
                                    <td><?php echo e($homePageSlider->id); ?></td>
                                    <td>
                                        <img
                                            src="<?php echo e($homePageSlider->path); ?>"
                                            class="w-100 shadow-1-strong rounded mb-4 img-fluid"
                                            alt="slider"
                                            style="height: 100px; max-width: 70%;"
                                        />
                                    </td>
									<td><?php echo e($homePageSlider->status); ?></td>
									<td><?php echo e(date('d/m/Y', strtotime($homePageSlider->date_added))); ?></td>
                                    <td>
                                        <?php if(auth()->user()->role_id == 1): ?>
                                        <a href="homePageSlider/<?php echo e($homePageSlider->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                        <button type="button" class="btn btn-clean  btn-sm btn-icon servideletebtn"><i class="fa fa-trash"></i></button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- data table end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
	<script type="text/javascript">

		$(document).ready(function() {
			$.ajaxSetup({
			    headers: {
			        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			    }
			});
			$('#dataTable').on('click', '.servideletebtn', function(e) {
				e.preventDefault();
				var id = $(this).closest("tr").find('.deleted_id').val();
				// alert(id);
				swal({
				  title: "Are you sure?",
				  text: "Once deleted, you will not be able to recover this Record!",
				  icon: "warning",
				  buttons: true,
				  dangerMode: true,
				})
				.then((willDelete) => {
				  if (willDelete) {
				  		var data = {
				  			"_token" : $('input[name="csrf-token"]').val(),
				  			"id" : id
				  		};
                        $.ajax({
                        type: "GET",
                        url: 'homePageSlider/delete/'+id,
                        data:data,
                        success: function(response)
                        {
                            swal(response.status, {
                                icon: "success",
                            })
                            .then((result) => {
                                location.reload();
                            });
                        }
                        });
				  }

				});
			});
		});
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/homePageSlider/index.blade.php ENDPATH**/ ?>