

<?php $__env->startSection('title', 'Donations'); ?>

<?php $__env->startSection('content'); ?>
	<!-- data table start -->
    <div class="col-12 mt-1">
        <div class="card">
            <div class="card-body">

				<div class="clearfix mb-3">
                    <h4 class="header-title float-left"><i class="fa fa-gift custom-icon"></i> Donations Table</h4>
                </div>

				<table id="dataTable" class="table text-center" data-counter="<?php echo e($counter); ?>">
					<thead class="bg-purple text-white">
						<tr>
							<th class="all">#</th>
							<th class="all">Sender</th>
							<th class="all">Receiver</th>
							<th class="all">Amount Transfered</th>
							<th class="all">Creation Date</th>
						</tr>
					</thead>
					<tbody>
						<?php echo $__env->make('admin.donations.fetch-data-by-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</tbody>
				</table>
				
				<?php if($existingRows > $counter): ?>
				<a href="#" class="btn bg-purple text-white mt-3" id="load-more" data-existing-rows="<?php echo e($existingRows); ?>">Show More</a>
				<?php endif; ?>
				
            </div>
        </div>
    </div>
    <!-- data table end -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>

		$('#load-more').on('click', function(e) {
			e.preventDefault();

			var counter = $('table').data('counter');
			var existingRows = $(this).data('existingRows');

			if(existingRows < counter + 50) {
				$(this).fadeOut();
			}


			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				} 
			});

			$.ajax({
				type: "POST",
				url: "<?php echo e(Route('donations.loadMore')); ?>",
				data: {counter: counter},
				success: function(data) {
					$('table').data('counter', counter + 50);
						
					$('tbody').append(data);
				}
			});

		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/donations/index.blade.php ENDPATH**/ ?>