

<?php $__env->startSection('title'); ?>
    <?php echo e(isset($customer) ? 'Customer ' . $customer->firstname : 'Create Customer'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="loader-container hidden">
        <div class="loader-spinner"></div>
    </div>

    <!-- Textual inputs start -->
    <div class="col-12 mt-1">

        <div class="card">
            <div class="card-body">
                <h4 class="header-title">
                    Customer Info
                </h4>
                <table class="table">
                    <thead class="bg-purple text-white">
                    <tr>
                        <th scope="col" class="text-capitalize">fullname</th>
                        <th scope="col"><?php echo e($customer->firstname); ?> <?php echo e($customer->lastname); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="text-capitalize">email</td>
                            <td><?php echo e($customer->email); ?></td>
                        </tr>
                        <tr>
                            <td class="text-capitalize">phoneNumber</td>
                            <td><?php echo e($customer->phoneNumber); ?></td>
                        </tr>
                        <?php if(isset($customer->address)): ?>
                        <tr>
                            <td class="text-capitalize">address</td>
                            <td><?php echo e($customer->address->address); ?></td>
                        </tr>
                        <tr>
                            <td class="text-capitalize">governorate</td>
                            <td><?php echo e($customer->address->govern); ?></td>
                        </tr>
                        <?php endif; ?>

                        <tr>
                            <td class="text-capitalize">Birthday</td>
                            <td><?php echo e($customer->birthday); ?></td>
                        </tr>
                        <?php if(isset($customer->Note)): ?>
                        <tr>
                            <td class="text-capitalize">Note</td>
                            <td><?php echo e($customer->note); ?></td>
                        </tr>
                        <?php endif; ?>
                       
                        <tr>
                            <td class="text-capitalize">Active</td>
                            <td><?php echo e($customer->active == 1 ? 'Yes' : 'No'); ?></td>
                        </tr>
                        <tr>
                            <td class="text-capitalize">guest</td>
                            <td><?php echo e($customer->guest == 1 ? 'Yes' : 'No'); ?></td>
                        </tr>
                        <tr>
                            <td class="text-capitalize">Date Of Join</td>
                            <td><?php echo e(date('d-m-Y', strtotime($customer->date_add))); ?></td>
                        </tr>
                    </tbody>
                </table>

            </div>
        </div>

        
        <?php if(count($productsSubscription) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Customer Subscriptions products
                </h4>
                <div class="data-tables">
                    <table id="dataTable">
                        <thead class="bg-purple text-white">
                        <tr>
                            <th class="all">ProductID</th>
                            <th class="all">Product</th>
                            <th class="all" >Subscription Amount</th>
                            <th class="all" >Date Of Subscription</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            <?php $__currentLoopData = $productsSubscription; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productSubscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(isset($productSubscription->product)): ?>
                            <?php $productImages = explode(', ', $productSubscription->product->images); ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(url('admin/products/'.$productSubscription->product->id)); ?>" class="text-purple">
                                        <?php echo e($productSubscription->product->id); ?>

                                    </a>
                                </td>
                                <td>
                                    <img src="<?php echo e(asset('/uploads/products/'.$productImages[0])); ?>"
                                        class="avatar avatar-sm me-3" alt="xd">
                                    <?php echo e($productSubscription->product->name); ?>

                                </td>
                                <td><?php echo e($productSubscription->subscription_amount); ?></td>
                                <td><?php echo e(date('d M Y', strtotime($productSubscription->date_added))); ?></td>
                            </tr>
                            <?php $i++; ?>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        
        <?php if(count($freeProductsSubscription) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Customer Subscriptions Freegift Products
                </h4>
                <div class="data-tables">
                    <table id="dataTable2">
                        <thead class="bg-purple text-white">
                        <tr>
                            <th class="all">ProductID</th>
                            <th class="all">Product</th>
                            <th class="all">Subscription Amount</th>
                            <th class="all">Date Of Subscription</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            <?php $__currentLoopData = $freeProductsSubscription; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $freeProductSubscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(isset($freeProductSubscription->product)): ?>
                            <?php $productImages = explode(', ', $freeProductSubscription->product->images); ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(url('admin/freegift_products/'.$freeProductSubscription->product->id)); ?>" class="text-purple">
                                        <?php echo e($freeProductSubscription->product->id); ?>

                                    </a>
                                </td>
                                <td>
                                    <img src="<?php echo e(asset('/uploads/products/'.$productImages[0])); ?>"
                                        class="avatar avatar-sm me-3" alt="xd">
                                    <?php echo e($freeProductSubscription->product->name); ?>

                                </td>
                                <td><?php echo e($freeProductSubscription->subscription_amount); ?></td>
                                <td><?php echo e(date('d M Y', strtotime($freeProductSubscription->date_added))); ?></td>
                            </tr>
                            <?php $i++; ?>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>

        
        <?php if(count($refund_requests) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Customer refund requests
                </h4>
                <div class="data-tables">
                    <table id="dataTable3">
                        <thead class="bg-purple text-white">
                        <tr>
                            <th class="all">#</th>
                            <th class="all">Amount</th>
                            <th class="all">Status</th>
                            <th class="all">Date</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            <?php $__currentLoopData = $refund_requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $refund_request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i); ?></td>
                                <td><?php echo e($refund_request->amount); ?></td>
                                <?php if($refund_request->status == 1): ?>
                                <td>Complete <i class="fa fa-lightbulb-o ml-2 green"></i></td>
                                <?php else: ?>
                                <td>Not Complete <i class="fa fa-lightbulb-o ml-2 red"></i></td>
                                <?php endif; ?>
                                <td><?php echo e(date('d M Y', strtotime($refund_request->date_added))); ?></td>
                            </tr>
                            <?php $i++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>

        
        <?php if(count($recharge_transactions) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Customer recharge transactions
                </h4>
                <div class="data-tables">
                    <table id="dataTable4">
                        <thead class="bg-purple text-white">
                        <tr>
                            <th class="all">#</th>
                            <th class="all">Amount</th>
                            <th class="all">Payment Method</th>
                            <th class="all">Status</th>
                            <th class="all">Date</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $recharge_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recharge_transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($recharge_transaction->id); ?></td>
                                <td><?php echo e($recharge_transaction->recharge_amount); ?></td>
                                <td><?php echo e($recharge_transaction->payment_method); ?></td>
                                <?php if($recharge_transaction->state == 5): ?>
                                <td>Success </td>
                                <?php elseif($recharge_transaction->state == 10): ?>
                                <td>Failed </td>
                                <?php else: ?>
                                <td>Pending </td>
                                <?php endif; ?>
                                <td><?php echo e(date('d M Y', strtotime($recharge_transaction->date_added))); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>

        
        <?php if(count($winning_products) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Winning products
                </h4>
                <table class="table">
                    <thead class="bg-purple text-white">
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Product</th>
                        <th scope="col">Subscription Amount</th>
                        <th scope="col">Winning Date</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $winning_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $winning_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $product = $winning_product->getProduct($winning_product->product_id, $winning_product->subscription_amount)?>
                        <tr>
                            <td><?php echo e($i); ?></td>
                            <td><?php echo e($product['productName']); ?></td>
                            <td><?php echo e($winning_product->subscription_amount); ?></td>
                            <td><?php echo e(date('d M Y', strtotime($winning_product->date_added))); ?></td>
                        </tr>
                        <?php $i++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        
        <?php if(count($notifications) > 0): ?>
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Customer Notifications
                </h4>
                <table class="table">
                    <thead class="bg-purple text-white">
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Notification Content</th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($i); ?></td>
                            <td><?php echo e($notification->notification_content); ?></td>
                        </tr>
                        <?php $i++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        <?php if(auth()->user()->role_id == 1): ?>
        
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Send Notification
                </h4>
                <form>
                    <div class="form-group">
                        <label for="notification_title" class="col-form-label">Notification Title</label>
                        <input type="text" class="form-control" name="notification_title" placeholder="Notification Title">
                    </div>
                    <div class="form-group">
                        <label for="scheduled_date" class="col-form-label">Scheduled Date</label>
						<input type="datetime-local" class="form-control" name="scheduled_date" placeholder="Scheduled Date">
					</div>
                    <button id="send-notification" class="btn btn-danger mt-4 pr-4 pl-4">
                        Send Notifications
                    </button>
                </form>
            </div>
        </div>
        
        
        <div class="card mt-4">
            <div class="card-body">
                <h4 class="header-title">
                    Customer Wallet
                </h4>
                <?php if(isset($customer->wallet)): ?>
                <form method="POST" action="<?php echo e(route('customers.updateWallet',['id_customer'=>$customer->id_customer])); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="form-group" style="max-width: 200px">
                        <label for="amount" class="col-form-label">Wallet Amount</label>
                        <input type="number" class="form-control" name="amount" min="0" value="<?php echo e($customer->wallet->amount); ?>">
                        <?php if($errors->has('amount')): ?>
                            <p class="text-danger help"><?php echo e($errors->first('amount')); ?></p>
                        <?php endif; ?>
                    </div>
                    <button id="send-notification" class="btn btn-danger mt-4 pr-4 pl-4">
                        Update Wallet
                    </button>
                </form>
                <?php else: ?>
                <div class="form-group">
                    <p class="text-danger help">This Customer Don't Have Wallet</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <?php endif; ?>
        
    </div>
    <!-- Textual inputs end -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script>

		$('#send-notification').on('click', function(e) {
			e.preventDefault();

			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				} 
			});

            var usersIds = [];

			var notification_title = $('input[name="notification_title"]').val();
			var scheduled_date = $('input[name="scheduled_date"]').val();
            var user_id = `<?php echo $customer->id_customer; ?>`;
            usersIds[0] = user_id;			

			if(notification_title == '') {

				Swal.fire({
					icon: 'error',
					title: 'Please fill in the required fields !',
				});

			} else {

                var data = {
                    "users_array": usersIds,
                    "notification_title": notification_title,
                    "scheduled_date": scheduled_date
                };

                // showing loading
                $('.loader-container').removeClass('hidden');

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(Route('customers.send.notifications')); ?>",
                    data: data,
                    success: function(response) {
                        
                        // remove loading
                        $('.loader-container').addClass('hidden');
                        
                        if(response.status == 1) {
                            Swal.fire(response.message, '' , 'success').then((result) => {
                                location.reload();
                            });
                        } else {
                            Swal.fire(response.message, '' , 'error');
                        }
                    }
                });

			}

		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\bgneh\resources\views/admin/customers/form.blade.php ENDPATH**/ ?>